/*
 * RemoveTextFrameLAbels.jsx
 * Javascript for InDesign CC - CS3
 * Version date: 20140630
 * 
 * Remove any set Script Labels from all text frames text frames.
 * 
 * 
 * DISCLAIMER:
 * ===============
 * Absolutely no warranty. Use it as is or modify it to match your needs
 *
 * Author: Andreas Imhof, www.aiedv.ch
 */

var totalTextFrames = 0,
	totalTextFramesLabels_removed = 0;

function remove_TextFrameLabels() {
	var theDocument = app.activeDocument;
	for (var pagectr = 0; pagectr < theDocument.pages.length; pagectr++) {
		for (var framectr = 0; framectr < theDocument.pages.item(pagectr).textFrames.length; framectr++) {
			totalTextFrames++;
			var theTextFrame = theDocument.pages.item(pagectr).textFrames.item(framectr);
			// get first boxes of a chain only
			if (theTextFrame.label != "") {
				theTextFrame.label = "";
				totalTextFramesLabels_removed++;
			}
		}
	}
	alert(totalTextFramesLabels_removed + " labels removed from " + totalTextFrames + " total text boxes");
}

remove_TextFrameLabels();
